/*
 * Decompiled with CFR 0.152.
 */
package jp.axer.cocoainput;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.axer.cocoainput.arch.darwin.DarwinController;
import jp.axer.cocoainput.arch.dummy.DummyController;
import jp.axer.cocoainput.arch.win.WinController;
import jp.axer.cocoainput.arch.x11.X11Controller;
import jp.axer.cocoainput.plugin.CocoaInputController;
import jp.axer.cocoainput.util.ConfigPack;
import jp.axer.cocoainput.util.ModLogger;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.IOUtils;

public class CocoaInput {
    private static CocoaInputController controller;
    private static String zipsource;
    public static ConfigPack config;

    public CocoaInput(String loader, String zipfile) {
        ModLogger.log("Modloader:" + loader, new Object[0]);
        zipsource = zipfile;
        try {
            if (Platform.isMac()) {
                CocoaInput.applyController(new DarwinController());
            } else if (Platform.isWindows()) {
                CocoaInput.applyController(new WinController());
            } else if (Platform.isX11()) {
                CocoaInput.applyController(new X11Controller());
            } else {
                ModLogger.log("CocoaInput cannot find appropriate Controller in running OS.", new Object[0]);
                CocoaInput.applyController(new DummyController());
            }
            ModLogger.log("CocoaInput has been initialized.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getScreenScaledFactor() {
        return class_310.method_1551().method_22683().method_4495();
    }

    public static void applyController(CocoaInputController controller) throws IOException {
        CocoaInput.controller = controller;
        ModLogger.log("CocoaInput is now using controller:" + controller.getClass().toString(), new Object[0]);
    }

    public static CocoaInputController getController() {
        return controller;
    }

    public void distributeScreen(class_437 sc) {
        if (CocoaInput.getController() != null) {
            CocoaInput.getController().screenOpenNotify(sc);
        }
    }

    public static void copyLibrary(String libraryName, String libraryPath) throws IOException {
        InputStream libFile;
        if (zipsource == null) {
            libFile = CocoaInput.class.getResourceAsStream("/" + libraryPath);
        } else {
            try {
                ZipFile jarfile = new ZipFile(zipsource);
                libFile = jarfile.getInputStream(new ZipEntry(libraryPath));
            }
            catch (FileNotFoundException e) {
                ModLogger.log("Couldn't get library path. Is this debug mode?'", new Object[0]);
                libFile = ClassLoader.getSystemResourceAsStream(libraryPath);
            }
        }
        File nativeDir = new File(class_310.method_1551().field_1697.getAbsolutePath().concat("/native"));
        File copyLibFile = new File(class_310.method_1551().field_1697.getAbsolutePath().concat("/native/" + libraryName));
        try {
            nativeDir.mkdir();
            FileOutputStream fos = new FileOutputStream(copyLibFile);
            copyLibFile.createNewFile();
            IOUtils.copy((InputStream)libFile, (OutputStream)fos);
            fos.close();
        }
        catch (IOException e1) {
            ModLogger.error("Attempted to copy library to ./native/" + libraryName + " but failed.", new Object[0]);
            throw e1;
        }
        System.setProperty("jna.library.path", nativeDir.getAbsolutePath());
        ModLogger.log("CocoaInput has copied library to native directory.", new Object[0]);
    }

    static {
        config = ConfigPack.defaultConfig;
    }
}

