/*
 * Decompiled with CFR 0.152.
 */
package jp.axer.cocoainput.arch.darwin;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.UUID;
import jp.axer.cocoainput.CocoaInput;
import jp.axer.cocoainput.arch.darwin.CallbackFunction;
import jp.axer.cocoainput.arch.darwin.Handle;
import jp.axer.cocoainput.plugin.IMEOperator;
import jp.axer.cocoainput.plugin.IMEReceiver;
import jp.axer.cocoainput.util.ModLogger;
import jp.axer.cocoainput.util.Rect;

public class DarwinIMEOperator
implements IMEOperator {
    IMEReceiver owner;
    String uuid;
    CallbackFunction.Func_insertText insertText_p;
    CallbackFunction.Func_setMarkedText setMarkedText_p;
    CallbackFunction.Func_firstRectForCharacterRange firstRectForCharacterRange_p;
    boolean isFocused = false;

    public DarwinIMEOperator(IMEReceiver field) {
        this.owner = field;
        this.uuid = UUID.randomUUID().toString();
        this.insertText_p = new CallbackFunction.Func_insertText(){

            @Override
            public void invoke(String str, int position, int length) {
                ModLogger.debug("Textfield " + DarwinIMEOperator.this.uuid + " received inserted text.", new Object[0]);
                DarwinIMEOperator.this.owner.insertText(str, position, length);
            }
        };
        this.setMarkedText_p = new CallbackFunction.Func_setMarkedText(){

            @Override
            public void invoke(String str, int position1, int length1, int position2, int length2) {
                ModLogger.debug("MarkedText changed at " + DarwinIMEOperator.this.uuid + ".", new Object[0]);
                DarwinIMEOperator.this.owner.setMarkedText(str, position1, length1, position2, length2);
            }
        };
        this.firstRectForCharacterRange_p = new CallbackFunction.Func_firstRectForCharacterRange(){

            @Override
            public Pointer invoke() {
                ModLogger.debug("Called to determine where to draw.", new Object[0]);
                Rect point = DarwinIMEOperator.this.owner.getRect();
                float[] buff = point == null ? new float[]{0.0f, 0.0f, 0.0f, 0.0f} : new float[]{point.getX(), point.getY(), point.getWidth(), point.getHeight()};
                double factor = CocoaInput.getScreenScaledFactor();
                buff[0] = (float)((double)buff[0] * factor);
                buff[1] = (float)((double)buff[1] * factor);
                buff[2] = (float)((double)buff[2] * factor);
                buff[3] = (float)((double)buff[3] * factor);
                Memory ret = new Memory(16L);
                ret.write(0L, buff, 0, 4);
                return ret;
            }
        };
        ModLogger.log("IMEOperator addInstance: " + this.uuid, new Object[0]);
        Handle.INSTANCE.addInstance(this.uuid, this.insertText_p, this.setMarkedText_p, this.firstRectForCharacterRange_p);
    }

    @Override
    public void discardMarkedText() {
        Handle.INSTANCE.discardMarkedText(this.uuid);
    }

    @Override
    public void removeInstance() {
        Handle.INSTANCE.removeInstance(this.uuid);
    }

    @Override
    public void setFocused(boolean yn) {
        if (yn != this.isFocused) {
            ModLogger.log("IMEOperator.setFocused: " + (yn ? "true" : "false"), new Object[0]);
            Handle.INSTANCE.setIfReceiveEvent(this.uuid, yn ? 1 : 0);
            this.isFocused = yn;
        }
    }
}

