/*
 * Decompiled with CFR 0.152.
 */
package jp.axer.cocoainput.plugin;

import jp.axer.cocoainput.CocoaInput;
import jp.axer.cocoainput.arch.win.Logger;
import jp.axer.cocoainput.util.PreeditFormatter;
import jp.axer.cocoainput.util.Rect;
import jp.axer.cocoainput.util.Tuple3;
import net.minecraft.class_310;

public abstract class IMEReceiver {
    private int length = 0;
    protected boolean cursorVisible = true;
    private boolean preeditBegin = false;
    protected int originalCursorPosition = 0;

    public void insertText(String aString, int position1, int length1) {
        Logger.log("just comming:(" + aString + ") now:(" + this.getText() + ")", new Object[0]);
        if (!this.preeditBegin) {
            this.originalCursorPosition = this.getCursorPos();
        }
        this.preeditBegin = false;
        this.cursorVisible = true;
        this.setText(new StringBuffer(this.getText()).replace(this.originalCursorPosition, this.originalCursorPosition + this.length, "").toString());
        this.length = 0;
        this.setCursorPos(this.originalCursorPosition);
        this.setSelectionPos(this.originalCursorPosition);
        if (CocoaInput.config.isNativeCharTyped()) {
            this.insertTextNative(aString);
        } else {
            this.insertTextEmurated(aString);
        }
    }

    public void setMarkedText(String aString, int position1, int length1, int position2, int length2) {
        boolean hasCaret;
        int caretPosition;
        Object commitString;
        if (!this.preeditBegin) {
            this.originalCursorPosition = this.getCursorPos();
            this.preeditBegin = true;
        }
        if (CocoaInput.config.isAdvancedPreeditDraw()) {
            Tuple3<String, Integer, Boolean> formattedText = PreeditFormatter.formatMarkedText(aString, position1, length1);
            commitString = formattedText._1();
            caretPosition = formattedText._2() + 4;
            hasCaret = formattedText._3();
        } else {
            hasCaret = true;
            caretPosition = 0;
            commitString = "\u00a7n" + aString + "\u00a7r";
        }
        this.setText(new StringBuffer(this.getText()).replace(this.originalCursorPosition, this.originalCursorPosition + this.length, (String)commitString).toString());
        this.length = ((String)commitString).length();
        if (hasCaret) {
            this.cursorVisible = true;
            this.setCursorPos(this.originalCursorPosition + caretPosition);
            this.setSelectionPos(this.originalCursorPosition + caretPosition);
        } else {
            this.cursorVisible = false;
            this.setCursorInvisible();
            this.setCursorPos(this.originalCursorPosition);
            this.setSelectionPos(this.originalCursorPosition);
        }
    }

    public abstract Rect getRect();

    protected abstract void setText(String var1);

    protected abstract String getText();

    protected abstract void setCursorInvisible();

    protected abstract int getCursorPos();

    protected abstract void setCursorPos(int var1);

    protected abstract void setSelectionPos(int var1);

    protected void insertTextNative(String text) {
        for (char c : text.toCharArray()) {
            class_310 instance = class_310.method_1551();
            instance.field_1774.method_1457(instance.method_22683().method_4490(), (int)c, 0);
        }
    }

    protected void insertTextEmurated(String aString) {
        this.setText(new StringBuffer(this.getText()).replace(this.getCursorPos(), this.getCursorPos(), aString.substring(0, aString.length())).toString());
        this.length = 0;
        this.setCursorPos(this.getCursorPos() + aString.length());
        this.notifyParent(this.getText());
    }

    protected void notifyParent(String text) {
    }
}

