/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.vendored.joml.Vector4f;

public class ClearPassCreator {
    public static ImmutableList<ClearPass> createClearPasses(RenderTargets renderTargets, boolean bl, PackRenderTargetDirectives packRenderTargetDirectives) {
        int n2 = GlStateManager._getInteger((int)34852);
        HashMap<Vector4f, IntList> hashMap = new HashMap<Vector4f, IntList>();
        packRenderTargetDirectives.getRenderTargetSettings().forEach((n, renderTargetSettings) -> {
            int n2 = n;
            if (bl || renderTargetSettings.shouldClear()) {
                Vector4f vector4f2 = n2 == 0 ? null : (n2 == 1 ? new Vector4f(1.0f, 1.0f, 1.0f, 1.0f) : new Vector4f(0.0f, 0.0f, 0.0f, 0.0f));
                Vector4f vector4f3 = renderTargetSettings.getClearColor().orElse(vector4f2);
                hashMap.computeIfAbsent(vector4f3, vector4f -> new IntArrayList()).add(n2);
            }
        });
        ArrayList arrayList = new ArrayList();
        hashMap.forEach((vector4f, intList) -> {
            int n2 = 0;
            while (n2 < intList.size()) {
                int[] nArray = new int[Math.min(intList.size() - n2, n2)];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = intList.getInt(n2);
                    ++n2;
                }
                arrayList.add(new ClearPass((Vector4f)vector4f, renderTargets::getCurrentWidth, renderTargets::getCurrentHeight, renderTargets.createFramebufferWritingToAlt(nArray), 16384));
                arrayList.add(new ClearPass((Vector4f)vector4f, renderTargets::getCurrentWidth, renderTargets::getCurrentHeight, renderTargets.createFramebufferWritingToMain(nArray), 16384));
            }
        });
        return ImmutableList.copyOf(arrayList);
    }

    public static ImmutableList<ClearPass> createShadowClearPasses(ShadowRenderTargets shadowRenderTargets, boolean bl, PackShadowDirectives packShadowDirectives) {
        ArrayList<ClearPass> arrayList = new ArrayList<ClearPass>();
        for (int i = 0; i < shadowRenderTargets.getNumColorTextures(); ++i) {
            if (i >= packShadowDirectives.getColorSamplingSettings().size()) continue;
            if (bl || ((PackShadowDirectives.SamplingSettings)packShadowDirectives.getColorSamplingSettings().get(i)).getClear()) {
                PackShadowDirectives.SamplingSettings samplingSettings = (PackShadowDirectives.SamplingSettings)packShadowDirectives.getColorSamplingSettings().get(i);
                arrayList.add(new ClearPass(samplingSettings.getClearColor(), shadowRenderTargets::getResolution, shadowRenderTargets::getResolution, shadowRenderTargets.getFramebufferForColorTexture(i), 16640));
                continue;
            }
            arrayList.add(new ClearPass(new Vector4f(1.0f), shadowRenderTargets::getResolution, shadowRenderTargets::getResolution, shadowRenderTargets.getFramebufferForColorTexture(i), 256));
        }
        return ImmutableList.copyOf(arrayList);
    }
}

