/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import me.jellysquid.mods.sodium.client.model.vertex.type.ChunkVertexType;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.newshader.TriforcePatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.minecraft.class_2960;

public class SodiumTerrainPipeline {
    String terrainVertex;
    String terrainGeometry;
    String terrainFragment;
    String terrainCutoutFragment;
    GlFramebuffer terrainFramebuffer;
    BlendModeOverride terrainBlendOverride;
    AlphaTest terrainCutoutAlpha;
    String translucentVertex;
    String translucentGeometry;
    String translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    AlphaTest translucentAlpha;
    String shadowVertex;
    String shadowGeometry;
    String shadowFragment;
    String shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride = BlendModeOverride.OFF;
    AlphaTest shadowAlpha;
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;

    public SodiumTerrainPipeline(WorldRenderingPipeline worldRenderingPipeline, ProgramSet programSet, IntFunction<ProgramSamplers> intFunction, IntFunction<ProgramSamplers> intFunction2, IntFunction<ProgramImages> intFunction3, IntFunction<ProgramImages> intFunction4, RenderTargets renderTargets, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, GlFramebuffer glFramebuffer) {
        this.parent = Objects.requireNonNull(worldRenderingPipeline);
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), optional);
        this.programSet = programSet;
        this.shadowFramebuffer = glFramebuffer;
        optional.ifPresent(programSource -> {
            this.terrainFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, programSource.getDirectives().getDrawBuffers());
        });
        optional2.ifPresent(programSource -> {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, programSource.getDirectives().getDrawBuffers());
        });
        if (this.terrainFramebuffer == null) {
            this.terrainFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        }
        if (this.translucentFramebuffer == null) {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, new int[]{0});
        }
        this.createTerrainSamplers = intFunction;
        this.createShadowSamplers = intFunction2;
        this.createTerrainImages = intFunction3;
        this.createShadowImages = intFunction4;
    }

    public void patchShaders(ChunkVertexType chunkVertexType) {
        String string;
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(true, true, false, true, true);
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), optional);
        optional.ifPresent(programSource -> {
            this.terrainVertex = programSource.getVertexSource().orElse(null);
            this.terrainGeometry = programSource.getGeometrySource().orElse(null);
            this.terrainFragment = programSource.getFragmentSource().orElse(null);
            this.terrainBlendOverride = programSource.getDirectives().getBlendModeOverride();
            this.terrainCutoutAlpha = programSource.getDirectives().getAlphaTestOverride().orElse(AlphaTests.ONE_TENTH_ALPHA);
        });
        optional2.ifPresent(programSource -> {
            this.translucentVertex = programSource.getVertexSource().orElse(null);
            this.translucentGeometry = programSource.getGeometrySource().orElse(null);
            this.translucentFragment = programSource.getFragmentSource().orElse(null);
            this.translucentBlendOverride = programSource.getDirectives().getBlendModeOverride();
            this.translucentAlpha = programSource.getDirectives().getAlphaTestOverride().orElse(AlphaTest.ALWAYS);
        });
        this.programSet.getShadow().ifPresent(programSource -> {
            this.shadowVertex = programSource.getVertexSource().orElse(null);
            this.shadowGeometry = programSource.getGeometrySource().orElse(null);
            this.shadowFragment = programSource.getFragmentSource().orElse(null);
            this.shadowBlendOverride = programSource.getDirectives().getBlendModeOverride();
            this.shadowAlpha = programSource.getDirectives().getAlphaTestOverride().orElse(AlphaTests.NON_ZERO_ALPHA);
        });
        if (this.terrainVertex != null) {
            this.terrainVertex = TriforcePatcher.patchSodium(this.terrainVertex, ShaderType.VERTEX, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.translucentVertex != null) {
            this.translucentVertex = TriforcePatcher.patchSodium(this.translucentVertex, ShaderType.VERTEX, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.shadowVertex != null) {
            this.shadowVertex = TriforcePatcher.patchSodium(this.shadowVertex, ShaderType.VERTEX, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.terrainGeometry != null) {
            this.terrainGeometry = TriforcePatcher.patchSodium(this.terrainGeometry, ShaderType.GEOMETRY, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.translucentGeometry != null) {
            this.translucentGeometry = TriforcePatcher.patchSodium(this.translucentGeometry, ShaderType.GEOMETRY, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.shadowGeometry != null) {
            this.shadowGeometry = TriforcePatcher.patchSodium(this.shadowGeometry, ShaderType.GEOMETRY, null, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.terrainFragment != null) {
            string = this.terrainFragment;
            this.terrainFragment = TriforcePatcher.patchSodium(string, ShaderType.FRAGMENT, AlphaTest.ALWAYS, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
            this.terrainCutoutFragment = TriforcePatcher.patchSodium(string, ShaderType.FRAGMENT, this.terrainCutoutAlpha, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.translucentFragment != null) {
            this.translucentFragment = TriforcePatcher.patchSodium(this.translucentFragment, ShaderType.FRAGMENT, this.translucentAlpha, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
        if (this.shadowFragment != null) {
            string = this.shadowFragment;
            this.shadowFragment = TriforcePatcher.patchSodium(string, ShaderType.FRAGMENT, AlphaTest.ALWAYS, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
            this.shadowCutoutFragment = TriforcePatcher.patchSodium(string, ShaderType.FRAGMENT, this.shadowAlpha, shaderAttributeInputs, chunkVertexType.getPositionScale(), chunkVertexType.getPositionOffset(), chunkVertexType.getTextureScale());
        }
    }

    public Optional<String> getTerrainVertexShaderSource() {
        return Optional.ofNullable(this.terrainVertex);
    }

    public Optional<String> getTerrainGeometryShaderSource() {
        return Optional.ofNullable(this.terrainGeometry);
    }

    public Optional<String> getTerrainFragmentShaderSource() {
        return Optional.ofNullable(this.terrainFragment);
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.terrainCutoutFragment);
    }

    public GlFramebuffer getTerrainFramebuffer() {
        return this.terrainFramebuffer;
    }

    public BlendModeOverride getTerrainBlendOverride() {
        return this.terrainBlendOverride;
    }

    public Optional<AlphaTest> getTerrainCutoutAlpha() {
        return Optional.ofNullable(this.terrainCutoutAlpha);
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return Optional.ofNullable(this.translucentVertex);
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return Optional.ofNullable(this.translucentGeometry);
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return Optional.ofNullable(this.translucentFragment);
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public Optional<AlphaTest> getTranslucentAlpha() {
        return Optional.ofNullable(this.translucentAlpha);
    }

    public Optional<String> getShadowVertexShaderSource() {
        return Optional.ofNullable(this.shadowVertex);
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return Optional.ofNullable(this.shadowGeometry);
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return Optional.ofNullable(this.shadowFragment);
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return Optional.ofNullable(this.shadowCutoutFragment);
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public Optional<AlphaTest> getShadowAlpha() {
        return Optional.ofNullable(this.shadowAlpha);
    }

    public ProgramUniforms initUniforms(int n) {
        ProgramUniforms.Builder builder = ProgramUniforms.builder("<sodium shaders>", n);
        CommonUniforms.addCommonUniforms(builder, this.programSet.getPack().getIdMap(), this.programSet.getPackDirectives(), this.parent.getFrameUpdateNotifier(), FogMode.PER_VERTEX);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(builder);
        return builder.buildUniforms();
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int n) {
        return this.createTerrainSamplers.apply(n);
    }

    public ProgramSamplers initShadowSamplers(int n) {
        return this.createShadowSamplers.apply(n);
    }

    public ProgramImages initTerrainImages(int n) {
        return this.createTerrainImages.apply(n);
    }

    public ProgramImages initShadowImages(int n) {
        return this.createShadowImages.apply(n);
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static String parseSodiumImport(String string) {
        Pattern pattern = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + pattern + ")");
        }
        String string2 = matcher.group("namespace");
        String string3 = matcher.group("path");
        class_2960 class_29602 = new class_2960(string2, string3);
        return ShaderLoader.getShaderSource((class_2960)class_29602);
    }
}

