/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class JoinGroupEntry
extends ListScreenEntryBase<JoinGroupEntry> {
    protected static final ResourceLocation LOCK = new ResourceLocation("voicechat", "textures/icons/lock.png");
    protected static final Component GROUP_MEMBERS = Component.m_237115_((String)"message.voicechat.group_members").m_130940_(ChatFormatting.WHITE);
    protected static final int SKIN_SIZE = 12;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)74, (int)74, (int)74);
    protected static final int BG_FILL_SELECTED = FastColor.ARGB32.m_13660_((int)255, (int)90, (int)90, (int)90);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final ListScreenBase parent;
    protected final Minecraft minecraft;
    protected final Group group;

    public JoinGroupEntry(ListScreenBase parent, Group group) {
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.group = group;
    }

    public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        if (hovered) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL_SELECTED);
        } else {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        }
        boolean hasPassword = this.group.group.hasPassword();
        if (hasPassword) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)LOCK);
            Screen.m_93133_((PoseStack)poseStack, (int)(left + 4), (int)(top + height / 2 - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        MutableComponent groupName = Component.m_237113_((String)this.group.group.getName());
        Font font = this.minecraft.f_91062_;
        float f = left + 4 + (hasPassword ? 20 : 0);
        int n = top + height / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        font.m_92889_(poseStack, (Component)groupName, f, (float)(n - 9 / 2), PLAYER_NAME_COLOR);
        int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)groupName) + (hasPassword ? 20 : 0);
        int headsPerRow = (width - (4 + textWidth + 4 + 4)) / 13;
        int rows = 2;
        for (int i = 0; i < this.group.members.size(); ++i) {
            PlayerState state = this.group.members.get(i);
            int headXIndex = i / rows;
            int headYIndex = i % rows;
            if (i >= headsPerRow * rows) break;
            int headPosX = left + width - 12 - 4 - headXIndex * 13;
            int headPosY = top + height / 2 - 13 + 13 * headYIndex;
            poseStack.m_85836_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)GameProfileUtils.getSkin(state.getUuid()));
            poseStack.m_85837_((double)headPosX, (double)headPosY, 0.0);
            float scale = 1.5f;
            poseStack.m_85841_(scale, scale, scale);
            Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69478_();
            Screen.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
        if (hovered) {
            ArrayList tooltip = Lists.newArrayList();
            tooltip.add(GROUP_MEMBERS.m_7532_());
            int maxMembers = 10;
            for (int i = 0; i < this.group.getMembers().size(); ++i) {
                if (i >= maxMembers) {
                    tooltip.add(Component.m_237110_((String)"message.voicechat.more_members", (Object[])new Object[]{this.group.getMembers().size() - maxMembers}).m_130940_(ChatFormatting.GRAY).m_7532_());
                    break;
                }
                PlayerState state = this.group.getMembers().get(i);
                tooltip.add(Component.m_237113_((String)("  " + state.getName())).m_130940_(ChatFormatting.GRAY).m_7532_());
            }
            this.parent.postRender(() -> this.parent.m_96617_(poseStack, tooltip, mouseX, mouseY));
        }
    }

    public Group getGroup() {
        return this.group;
    }

    public static class Group {
        private final ClientGroup group;
        private final List<PlayerState> members;

        public Group(ClientGroup group) {
            this.group = group;
            this.members = new ArrayList<PlayerState>();
        }

        public ClientGroup getGroup() {
            return this.group;
        }

        public List<PlayerState> getMembers() {
            return this.members;
        }
    }
}

