/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class LocationSoundPacket
extends SoundPacket<LocationSoundPacket> {
    protected Vec3 location;
    protected float distance;

    public LocationSoundPacket(UUID sender, Vec3 location, byte[] data, long sequenceNumber, float distance, @Nullable String category) {
        super(sender, data, sequenceNumber, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket(UUID sender, short[] data, Vec3 location, float distance, @Nullable String category) {
        super(sender, data, category);
        this.location = location;
        this.distance = distance;
    }

    public LocationSoundPacket() {
    }

    public Vec3 getLocation() {
        return this.location;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public LocationSoundPacket fromBytes(FriendlyByteBuf buf) {
        LocationSoundPacket soundPacket = new LocationSoundPacket();
        soundPacket.sender = buf.m_130259_();
        soundPacket.location = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        soundPacket.data = buf.m_130052_();
        soundPacket.sequenceNumber = buf.readLong();
        soundPacket.distance = buf.readFloat();
        byte data = buf.readByte();
        if (this.hasFlag(data, (byte)2)) {
            soundPacket.category = buf.m_130136_(16);
        }
        return soundPacket;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.sender);
        buf.writeDouble(this.location.f_82479_);
        buf.writeDouble(this.location.f_82480_);
        buf.writeDouble(this.location.f_82481_);
        buf.m_130087_(this.data);
        buf.writeLong(this.sequenceNumber);
        buf.writeFloat(this.distance);
        byte data = 0;
        if (this.category != null) {
            data = this.setFlag(data, (byte)2);
        }
        buf.writeByte((int)data);
        if (this.category != null) {
            buf.m_130072_(this.category, 16);
        }
    }
}

